Search query: [Link](https://splunksearch.dell.com/en-US/app/search/search?earliest=-30d%40d&latest=now&q=search%20index%3Dpcf_logs%20cf_org_name%3DDCQOQuoteOrg%20cf_app_name%3D%22quote-svc%22%20msg.HttpRequestMethod%3DPATCH%20msg.UriPath%3D*paymentMethods*%0A%7C%20stats%20count%20by%20msg.ApiKeyClientName&display.page.search.mode=verbose&dispatch.sample_ratio=1&display.page.search.tab=visualizations&display.general.type=visualizations&display.events.type=list&display.statistics.sortColumn=count&display.statistics.sortDirection=desc&sid=1677018599.1360402_3D46FE11-8BB9-42D9-85C8-79DB7C5D8ED8),
Extract splunk logs - 

- DCQO all traffic all client keys, methods
```
index=pcf_logs cf_org_name=*DCQO* msg.HttpRequestMethod IN (GET, HEAD, POST, PATCH, PUT, DELETE)  
NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*")) 
NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*"))  
NOT ("msg.ApiKeyClientName"=null) 
| eval cstDateFormat = "%Y-%m-%d %H:%M:%S.%l %z" 
| eval cstTime = strftime(timestamp/1000000000, cstDateFormat) 
| eval cf_org = case((cf_org_name="DCQO-CartV3APJOrg" or cf_org_name="DCQO-CartV3EMEAOrg" or cf_org_name="DCQO-CartV3SvcOrg"), "DCQO-Cart", (cf_org_name="DCQOPriceMgrEMEOrg" or cf_org_name="DCQOPriceMgrOrg"), "DCQO-PriceMgr", (cf_org_name="DcqoSnapshotAmeOrg" or cf_org_name="DcqoSnapshotApjOrg" or cf_org_name="DcqoSnapshotEmeOrg"), "DCQO-Snapshot", true(), cf_org_name)  
| stats  count as totalcalls by msg.ApiKeyClientName cf_org msg.HttpRequestMethod
| sort  -totalcalls
```

- Quote endpoint calls with client name and distinct count of quote ID
```
index=pcf_logs cf_org_name=DCQOQuoteOrg msg.HttpRequestMethod IN (GET, HEAD, POST, PATCH, PUT, DELETE) 
NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*")) NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*"))
| eval cstDateFormat = "%Y-%m-%d %H:%M:%S.%l %z"
| eval cstTime = strftime(timestamp/1000000000, cstDateFormat)
| spath path=msg.RequestPath output=requestpath            ```extracts requestPath```
| spath path=msg.FullRequestUrl output=fullurl    ```extracts full request URL```
| rex field=requestpath "/quotes/(?<quote_id>[^/]{22,26})"  ```extracts quote ID, geo-partitioned```
```| rex field=requestpath "/quotes/(?<quote_id1>[^/]{22})"  extracts quote ID, non-geo partitioned```
| eval quote_id2 = coalesce(quote_id, quote_id1)
| eval quote_id3 = coalesce(quote_id2, "NA")
| eval extract1 = if(match(fullurl, "number"), "/v3/quotes/{no}.{v}/", requestpath) 
| eval extract2 = replace(extract1, quote_id3, "{quoteid}")
| eval extract2 = lower(extract2)
| eval extract3 = if(match(extract2, "{quoteid}/shipments/") AND match(extract2, "/items/"), "/v3/quotes/{quoteid}/shipments/{shipmentid}/items/{itemid}", if(match(extract2, "/shipments/"), "v3/quotes/{quoteid}/shipments/{shipmentid}", extract2))
| eval extract4 = if(match(extract3, "{quoteid}/items/"), "/v3/quotes/{quoteid}/items/{itemid}", extract3)
| eval extract5 = if(match(fullurl, "/properties/"), "/v3/quotes/{id}/properties/{key}", extract4)
| eval extract6 = if(match(fullurl, "/internal/quotes/"), "/v3/internal/quotes/{id}", extract5)
| eval extract7 = if(match(fullurl, "/priceadjustments/"), "/v3/quotes/{id}/priceAdjustments/{id}", extract6)
| eval extract8 = if(match(fullurl, "/salesreps/"), "/v3/quotes/{id}/salesReps/{id}", extract7)
| stats count as totalcalls, distinct_count(quote_id3) AS u_quoteid by msg.ApiKeyClientName, msg.HttpRequestMethod, extract8, quote_id3
| sort -totalcalls


Another query: Write only calling clients
index=pcf_logs
    cf_org_name="DCQOQuoteOrg"  
    msg.HttpRequestMethod IN (POST, PATCH, PUT, DELETE) 
NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*")) NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*"))
| eval cstDateFormat = "%Y-%m-%d"
| eval cstDate = strftime(timestamp/1000000000, cstDateFormat)
| stats count as callCount by msg.ApiKeyClientName | sort -callCount
```
- Overall DCQO client traffic, excluding health checks, summarized by method
```
index=pcf_logs cf_org_name=*DCQO* NOT (msg IN("*heartbeat*","*health*")) NOT (cf_app_name IN ("*green*","*prev*")) | stats count by msg.HttpRequestMethod | sort -count

Another query
index=pcf_logs cf_org_name=*DCQO* source=router NOT (cf_org_name IN (DCQOSplitOrg)) NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*")) NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*"))  
| rex field=msg "\"(?<method>.*) (?<path>.*) HTTP\/1\.1\" (?<status>\d+) (?<inputSize>\d+) (?<outputSize>\d+) \"-\" \"-\""  
| stats count by cf_org_name, cf_app_name, method
| eval cf_org = case((cf_org_name="DCQO-CartV3APJOrg" or cf_org_name="DCQO-CartV3EMEAOrg" or cf_org_name="DCQO-CartV3SvcOrg"), "DCQO-Cart", (cf_org_name="DCQOPriceMgrEMEOrg" or cf_org_name="DCQOPriceMgrOrg"), "DCQO-PriceMgr", (cf_org_name="DcqoSnapshotAmeOrg" or cf_org_name="DcqoSnapshotApjOrg" or cf_org_name="DcqoSnapshotEmeOrg"), "DCQO-Snapshot", true(), cf_org_name)
| stats sum(count) as "totCount" by cf_org, cf_app_name, HttpRequestMethod
| sort -totCount
| addtotals col=t row=f labelfield=cf_org label="Total count"
```


- Query that extracts response time or latency for all DCQO apps
```
ALL DCQO APPS

index=pcf_logs cf_org_name=*DCQO* source=router NOT (cf_org_name IN (DCQOSplitOrg)) NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*", "*internal*")) NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*"))
| eval cstDateFormat = "%Y-%m-%d"
| eval cstDate = strftime(timestamp/1000000000, cstDateFormat)
| eval cstHourFormat = "%H"
| eval cstHour = strftime(timestamp/1000000000, cstHourFormat)
| eval cstMinuteFormat = "%M"
| eval cstMinute = strftime(timestamp/1000000000, cstMinuteFormat)
| eval cstSecondFormat = "%S"
| eval cstSecond = strftime(timestamp/1000000000, cstSecondFormat)
| rex field=msg "\"(?<method>.*) (?<path>.*) HTTP\\/1\\.1\" (?<status>\\d+) (?<inputSize>\\d+) (?<outputSize>\\d+) \"-\" \"-\" "
| rex field=msg "response_time:(?<responseTime>[\d\.-]+)"
| rex field=msg "gorouter_time:(?<goRouterTime>[\d\.-]+)"
```| rex field=path "/quotes/(?<quote_id>[^/]{22,26})"  extracts quote ID, geo-partitioned```
| eval extract1 = lower(msg)
| eval region = if(match(extract1, "ame"), "AMER", if(match(extract1, "eme"),"EMEA",if(match(extract1,"apj"),"APJ","Global"))) 
| eval cf_org = case((cf_org_name="DCQO-CartV3APJOrg" or cf_org_name="DCQO-CartV3EMEAOrg" or cf_org_name="DCQO-CartV3SvcOrg"), "Cart", (cf_org_name="DCQOPriceMgrEMEOrg" or cf_org_name="DCQOPriceMgrOrg" or cf_org_name="DCQOPriceMgrAPJOrg"), "PriceMgr", (cf_org_name="DcqoSnapshotAmeOrg" or cf_org_name="DcqoSnapshotApjOrg" or cf_org_name="DcqoSnapshotEmeOrg"), "Snapshot", cf_org_name="DCQO-ContactSvcOrg", "Contact", cf_org_name="DcqoQuoteSearchOrg", "QuoteSearch", cf_org_name="DCQOItemOrg", "Item", cf_org_name="DCQOQuoteOrg", "Quote", cf_org_name="DCQOSalesOrderOrg", "SalesOrder", cf_org_name="DcqoOBGtwyOrg", "OBGateway", cf_org_name="DcqoMktPlceApiOrg", "Marketplace", cf_org_name="DCQO-CrtQotGtwyOrg", "C2QGateway", cf_org_name="DCQO-GIIQotGtwyOrg", "GiiGateway", true(), cf_org_name)
| eval http_group=case(
    like(status, "2%"), "2xx",
    like(status, "3%"), "3xx",
    like(status, "4%"), "4xx",
    like(status, "5%"), "5xx",
    true(), "Other"
)
| stats avg(responseTime) AS avg_response_time count as callCount by cf_org, method
| sort -callCount


DCQO QUOTE APP

index=pcf_logs cf_org_name=DCQOQuoteOrg 
NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*")) NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*"))
| eval cstDateFormat = "%Y-%m-%d %H:%M:%S.%l %z"
| eval cstTime = strftime(timestamp/1000000000, cstDateFormat) 
| rex field=msg "\"(?<method>.*) (?<requestpath>.*) HTTP\/1\.1\" (?<status>\d+) (?<inputSize>\d+) (?<outputSize>\d+) \"-\" \"-\""
| rex field=msg "response_time:(?<responseTime>[\d\.-]+)"
```| spath path=msg.RequestPath output=requestpath```            ```extracts requestPath```
```| spath path=msg.FullRequestUrl output=fullurl```    ```extracts full request URL```
| rex field=requestpath "/quotes/(?<quote_id>[^/]{22,26})"  ```extracts quote ID, geo-partitioned```
```| rex field=requestpath "quoteid(?<quote_id1>[^/]{22})"  extracts quote ID, non-geo partitioned```
| eval quote_id2 = coalesce(quote_id, quote_id1)
| eval quote_id3 = coalesce(quote_id2, "NA")
| eval extract1 = if(match(requestpath, "number="), "/v3/quotes/{no}.{v}/", requestpath)
| eval extract2 = replace(extract1, quote_id3, "{quoteid}")
| eval extract2 = lower(extract2)
| eval extract3 = if(match(extract2, "{quoteid}/shipments/") AND match(extract2, "/items/"), "/v3/quotes/{quoteid}/shipments/{shipmentid}/items/{itemid}", if(match(extract2, "/shipments/"), "v3/quotes/{quoteid}/shipments/{shipmentid}", extract2))
| eval extract4 = if(match(extract3, "{quoteid}/items/"), "/v3/quotes/{quoteid}/items/{itemid}", extract3)
| eval extract5 = if(match(extract4, "/properties/"), "/v3/quotes/{id}/properties/{key}", extract4)
| eval extract6 = if(match(extract5, "/internal/quotes/"), "/v3/internal/quotes/{id}", extract5)
| eval extract7 = if(match(extract6, "/priceadjustments/"), "/v3/quotes/{id}/priceAdjustments/{id}", extract6)
| eval extract8 = if(match(extract7, "/salesreps/"), "/v3/quotes/{id}/salesReps/{id}", extract7)
| eval extract9 = if(match(extract8, "quoteid="), "/v3/quotes/{quoteid}?{quoteid}/", extract8)
```| search method="POST"```
| stats avg(responseTime) AS avg_response_time count as totalcalls, distinct_count(quote_id3) AS u_quoteid by extract9, method
| sort -totalcalls

```

- Item type specific traffic and specific method (GET)
```
index=pcf_logs cf_org_name=DCQOItemOrg NOT (cf_org_name IN (DCQOSplitOrg)) NOT (msg IN("*heartbeat*","*health*","*/status/dependencies*")) NOT (cf_app_name IN ("*green*","*prev*","*perf*","*g4*","*g3*","*g2*","*g1*","*dev*")) NOT (msg.RequestPath IN ("*health", "*swagger*")) msg.HttpRequestMethod=GET
| eval cstDateFormat = "%Y-%m-%d %H:%M:%S.%l %z"
| spath path=msg.RequestPath output=requestpath            ```extracts requestPath```
| spath path=msg.Action output=action
| spath path=msg.itemType output=itemtype
| rex field=requestpath "/items/(?<item_id>[^/]{26})"  ```extracts item ID, geo-partitioned```
| rex field=requestpath "/v1/items/(?<item_id1>[^/]{26})"  ```extracts item ID1, geo-partitioned```
| eval item_id2 = coalesce(item_id, item_id1)
| eval extract1 = replace(requestpath, item_id2, "{itemid}")

| stats count as totalcalls, distinct_count(item_id2) AS u_itemid by msg.ApiKeyClientName, msg.HttpRequestMethod, extract1, item_id2
| sort -totalcalls
```
- Clients using specific endpoint for specific resource
~~~
index="pcf_logs" 
cf_space_name="PROD" 
msg.Path="/v1/salesOrders/UXlKbIGaykaAfZPlHoZylQ~001*" 
msg.Method = "PATCH" 
msg.ClientName = "*Premier*"

~~~

~~~
index="pcf_logs" 
cf_space_name="PROD" 
msg.Path="/v1/salesOrders/5piqKGSY5EGOlolOS8ka1w~002*"
| stats count by msg.Method, msg.Path, timestamp 
~~~

```
index=pcf_logs
    cf_org_name="DCQO-CartV3*Org" 
    cf_app_name IN (cart-amer, cart-emea, cart-apj) 
    msg.UriPath="*/v3/carts/An_yKbeoEEWhxYTjwiYpxw~002*" 
| eval cstDateFormat = "%Y-%m-%d %H:%M:%S.%l %z" 
| eval cstTime = strftime(timestamp/1000000000, cstDateFormat) 
| stats count by msg.HttpRequestMethod, msg.UriPath, timestamp, cstTime
```


- All DCQO app traffic
```
index=pcf_logs cf_org_name 
IN (DCQO-CartV3APJOrg, DCQO-CartV3EMEAOrg, DCQO-CartV3SvcOrg,DCQO-ContactSvcOrg, DCQO-CrtQotGtwyOrg, DCQO-GIIQotGtwyOrg, DCQO-SalesOrderOrg, DCQOItemOrg, DCQOPriceMgrAPJOrg, DCQOPriceMgrEMEOrg, DCQOPriceMgrOrg, DCQOQuoteOrg, DCQOSalesOrderOrg, DCQOSplitOrg, DcqoMktPlceApiOrg, DcqoOBGtwyOrg, DcqoOrdersOrg, DcqoQuoteSearchOrg, DcqoSnapshotAmeOrg, DcqoSnapshotApjOrg, DcqoSnapshotEmeOrg, DcqoSnapshotOrg)
NOT (cf_org_name IN (DCQOSplitOrg))
```

NGINX query
~~~
index="os" host="ngxpldcqo*" source="/var/log/nginx/quoteEditor.log"
| stats count by method
~~~

Extract traffic by client ID for - 
- DCQO level operations by HTTP method
  ~~~
  index=pcf_logs cf_org_name=*DCQO* msg.HttpRequestMethod=POST | stats count by cf_app_name
  ~~~
- Quote payment methods: 
   ~~~
   index=pcf_logs 
   cf_org_name=DCQOQuoteOrg 
   cf_app_name="quote-svc" 
   cf_space_name="Quote-V3"
   msg.HttpRequestMethod=PATCH 
   msg.UriPath=*paymentMethods* 
   | stats count by msg.ApiKeyClientName
   ~~~
- Item openBasketLite - 
  ~~~
  index=pcf_logs 
  cf_org_name=DCQOItemOrg 
  cf_app_name=*item-svc* 
  msg.HttpRequestMethod=GET 
  msg.UriPath=*openBasketLite* 
  | stats count by msg.ApiKeyClientName
  ~~~
- Item actions - 
~~~
index="pcf_logs" cf_org_name = "DCQOItemOrg" source="diego_cell"
| stats count by msg.ApiKeyClientName, msg.Action
~~~
- Cart
~~~
index=pcf_logs
cf_org_name="DCQO-CartV3*Org" 
cf_app_name IN (cart-amer, cart-emea, cart-apj) 
msg.HttpRequestMethod=POST 
msg.UriPath=*shipments* 
| stats count by msg.ApiKeyClientName


~~~
- Cart 4xx, 5xx errors in production 
```
index=pcf_logs cf_org_name=DCQO-CartV3*Org cf_app_name IN (cart-amer, cart-emea, cart-apj) source=diego_cell msg.HttpStatusCode IN (5*, 4*)
```

- QuoteSearch v1.1
~~~
index=pcf_logs 
cf_org_name=DCQOQuoteSearchOrg 
msg.HttpRequestMethod=POST 
msg.UriPath=*v1.1/quotes/search  
"msg.ApiKeyClientName"!=DCQO 
| stats  count by msg.ApiKeyClientName
~~~
- Gateway calling client
```
index=os sourcetype=* host="ngxpldcqo*" ua != "-" source=*openbasket* status=4* OR status=5*
| eval c_ip=xff
| `Get_CallingClient` 
| search CallingClient = "*" 
| stats count by CallingClient, status, method 
| sort - count
```

```
index="pcf_logs" cf_org_name="DcqoOBGtwyOrg" cf_app_name=openbasket-gateway-svc job=router
| rex field=msg "\"(?<cs_method>.*) (?<uri_path>.*) HTTP\/1\.1\" (?<sc_status>\d+)"
| search sc_status >= 400 sc_status != 404 
| eval route = uri_path
| eval route = replace(route, "/version/\d+", "/version/{version}")
| eval route = replace(route, "all[Qq]uotes/3[0-9]{12}/", "allquotes/{dellquote_no}/")
| eval route = replace(route, "all[Qq]uotes/[12][0-9]{12}/", "allquotes/{equote_no}/")
| eval route = replace(route, "all[Qq]uotes/[0-9]{5,9}/", "allquotes/{domsquote_no}/")
| eval route = if(match(route, "all[Qq]uotes/[0-9]+"), "/v3/allquotes (Bad Query)", route)
| eval route = if(match(route, "all[Qq]uotes\/.+\/version\/{version}.+"), "/v3/allquotes (Bad Query)", route)
| eval route = replace(route, "e[Qq]uotes/[12][0-9]{12}/", "equotes/{equote_no}/")
| eval route = replace(route, "e[Qq]uotes/[0-9]{5,9}/", "equotes/{domsquote_no}/")
| eval route = if(match(route, "e[Qq]uotes/[0-9]+"), "/v3/equotes (Bad Query)", route)
| eval route = if(match(route, "e[Qq]uotes\/.+\/version\/{version}.+"), "/v3/equotes (Bad Query)", route)
| eval route = replace(route, "orders/[0-9]{13}/", "orders/{dpid}/")
| eval route = replace(route, "/[A-Za-z0-9-_]{22}", "/{id}")
| eval route = lower(route)
| stats count by cs_method,sc_status,route
| sort - count
```
- SalesOrder
```
index=pcf_logs cf_org_name=DCQOSalesOrderOrg msg.HttpRequestMethod=POST 
| stats count by msg.ApiKeyClientName
```
- SalesOrder endpoints
```
index="pcf_logs" sourcetype="cf_log:**:PROD:salesOrder-svc"
      | where cf_org_name in ("DCQOSalesOrderOrg","DCQOSOAmerOrg","DCQOSOApjOrg","DCQOSOEmeaOrg")
      | rex field=msg "HTTP\/1\.1\" (?<httpStatus>\d\d\d)" 
      | rex field=msg "response_time:(?<msg_response_time>[-+]?[0-9]*\.?[0-9]+.)" 
      | rex field=msg " x_forwarded_for:.{1}(?<c_ip>\b\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\b),"
      | rex field=msg "(?<httpMethod>\w+) (?<Endpoints>(\/\w+){1,8})"
      | rex field=Endpoints "(?<baseUrl>(\/\w+){2}\/)(?<salesOrderId>[0-9a-zA-Z_-]{2,22})(?<urlPath>(\/\w+){1,3})"
      | eval TransactionType=case( httpStatus<400,"SuccessTrans", httpStatus>=400,"FailedTrans") 
      | eval hosting=mvindex(split(host,"-"),0) | stats count by cf_org_name, TransactionType, hosting, httpStatus, _time, c_ip, httpMethod, baseUrl, urlPath, Endpoints, msg_response_time
            
            | eval URL=case(Endpoints like "/v1/internal/salesOrders/%" ,"/v1/internal/salesOrders/{sales_order_id}", Endpoints like "/v1/internal/salesorders/%" ,"/v1/internal/salesorders/{sales_order_id}", Endpoints like "/v1/salesOrders/%" ,"/v1/salesorders/{sales_order_id}", Endpoints like "/v1/salesorders/%" ,"/v1/salesorders/{sales_order_id}")
            | lookup dnslookup clientip as c_ip 
            | `Get_CallingClient`
            | stats count by cf_org_name, httpMethod, URL
            | sort - count
```
- QuoteSearch search queries
```
index="pcf_logs" cf_org_name="DCQOQuoteSearchOrg" source=diego_cell "msg.ApiVersion"="1.1" | stats count by msg.SearchFields{} msg.ApiKeyClientName | sort -count

index="pcf_logs" cf_org_name="DCQOQuoteSearchOrg" source=diego_cell "msg.ApiVersion"="1.1" "msg.ApiKeyClientName"=DSA | timechart count by msg.SearchFields{} span=1D
```
- Quote performing GET, copy operations for older quotes
```
index=pcf_logs sourcetype="cf_log:DCQOQuoteOrg:Quote-V3*" cf_app_name IN ("quote-svc","quote-svc-amer") cf_space_name IN ("Quote-V3","Quote-V3-Amer") job="router" msg="*" NOT msg IN("*heartbeat*","*healthcheck*","*health*","*swagger*","*status*")| rex field=msg "(?<httpMethod>\w+) (?<baseUrl>(\/\w+){2}\/)(?<quoteId>[0-9a-zA-Z\-\_\~]{22,})(?<urlPath>(\/\w+){0,1}) HTTP/1.1\" (?<httpStatus>\d\d\d)" | search urlPath IN ("/mergequotes", "/copy", "") AND httpMethod IN ("POST", "GET") AND httpStatus < 300 | eval date=strftime(_time, "%F") | stats count by date, cf_app_name, httpMethod, httpStatus, quoteId, urlPath| dedup quoteId | sort date
```
- Cart count by specific path with resource ID
```
index=pcf_logs
cf_org_name="DCQO-CartV3*Org" 
cf_app_name IN (cart-amer, cart-emea, cart-apj) 
msg.UriPath=*/v3/carts/*
msg.ApiKeyClientName="Premier*"
| stats count by msg.UriPath, msg.HttpRequestMethod
```
- Cart query with generic endpoints
```
index="pcf_logs" cf_org_name="DCQO-CartV3*Org" cf_app_name IN (cart-amer, cart-emea, cart-apj) source="router"  | eval fields=split(msg," ") | eval AllErrors=mvindex(fields,6) | eval API=mvindex(fields,4) | eval METHOD=mvindex(fields,3) 
                    |eval Route=case(
                        match(API,"(?i)\/v3\/carts$"),"/v3/carts",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+$"),"/v3/carts/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+$"),"/v3/carts/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+$"),"/v3/carts/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/copy$"),"/v3/carts/*/copy",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/items\/list$"),"/v3/carts/*/items/list",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/items$"),"/v3/carts/*/items",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/items\/[A-Za-z0-9-_]+$"),"/v3/carts/*/items/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/items\/[A-Za-z0-9-_]+$"),"/v3/carts/*/items/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/items\/[A-Za-z0-9-_]+\/cficomments$"),"/v3/carts/*/items/*/cficomments",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price$"),"/v3/carts/*/price",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price$"),"/v3/carts/*/price",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/priceAdjustments$"),"/v3/carts/*/priceAdjustments",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/priceAdjustments$"),"/v3/carts/*/priceAdjustments",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/priceAdjustments\/[A-Za-z0-9-_]+$"),"/v3/carts/*/priceAdjustments/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price\/coupons\?couponCode=[A-Za-z0-9-_+%!.*,@#?)(~]+$"),"/v3/carts/*/price/coupons?*=*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price\/coupons\/[A-Za-z0-9-_+%!.*,@#?)(~]+$"),"/v3/carts/*/price/coupons/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price\/coupons$"),"/v3/carts/*/price/coupons",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price\/coupons$"),"/v3/carts/*/price/coupons",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/Properties$"),"/v3/carts/*/Properties",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/extededProperties"),"/v3/carts/*/extededProperties",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/price\/taxinformation$"),"/v3/carts/*/price/taxinformation",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/refresh$"),"/v3/carts/*/refresh",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/shipments$"),"/v3/carts/*/shipments",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/shipments\/[A-Za-z0-9-_]+$"),"/v3/carts/*/shipments/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/shipments\/[A-Za-z0-9-_]+$"),"/v3/carts/*/shipments/*",
                        match(API,"(?i)\/v3\/carts\/[A-Za-z0-9-_~]+\/validation$"),"/v3/carts/*/validation",
                        match(API,"(?i)\/v3\/internal\/carts\/[A-Za-z0-9-_~]+\/references$"),"/v3/internal/carts/*/references",
                        match(API,"(?i)\/v3\/internal\/carts\/[A-Za-z0-9-_~]+$"),"/v3/internal/carts/*",
                        match(API,"(?i)\/v3\/internal\/carts\/[A-Za-z0-9-_~]+\/carts:copy\/$"),"/v3/internal/carts/*/carts:copy",
                        match(API,"(?i)\/v3\/internal\/carts\/[A-Za-z0-9-_~]+$"),"/v3/internal/carts/*",
                        match(API,"(?i)\/v3\/status$"),"/v3/status",
                        match(API,"(?i)\/v3\/status\/dependencies$"),"/v3/status/dependencies",
                        match(API,"(?i)\/v3\/status\/modules$"),"/v3/status/modules",
                        match(API,"(?i)\/v3\/status\/featuretoggles$"),"/v3/status/featuretoggles",
                        match(API,"(?i)\/v3\/status\/sourcesystems$"),"/v3/status/sourcesystems",
                        match(API,"(?i)\/swagger[A-Za-z0-9-.\/]+$"),"/swagger",
                        1==1, "Others")
                    | stats count AS TotalCalls, count(eval(match(AllErrors, "4[0-9][0-9]"))) AS "4xx Errors", count(eval(match(AllErrors, "5[0-9][0-9]"))) AS "5xx Errors" by METHOD, Route, API
                    | eval TotalCalls = tostring(TotalCalls,"commas")
                    | eval MaxResponseTime = tostring(MaxResponseTime,"commas")
                    | eval perc95 = Round(perc95,2)
                    | eval perc98 = Round(perc98,2)
                    | eval AvgResponseTime = Round(AvgResponseTime,3) | sort Route
                    | eval METHOD=replace(METHOD, "\"", "")
```
- Cart 2 Quote Gateway
```
index="pcf_logs" 
cf_org_name="DCQO-CrtQotGtwyOrg" 
cf_app_name="cart-quote-gateway-svc"
| rex field=msg "\"(?<cs_method>.*) (?<uri_path>.*) HTTP\/1\.1\" (?<sc_status>\d+) .* response_time:(?<time_taken>\d+.\d+)"
| search uri_path="/v3/quotes*"

```

- Item service actions 
```
index=pcf_logs cf_org_name="DCqoItemOrg" source="diego_cell" msg.Action = "GetClearPriceItems" | timechart count,avg(msg.TimeTaken), perc95(msg.TimeTaken)
```